;; -------------------------------------------------------------------
;; Snowclimber 
;; -------------------------------------------------------------------
;; This file contains various methods that are useful in every part of
;; the production. Most of them are just references to the BIOS to
;; save space and make it fit in 2K.
;; -------------------------------------------------------------------

wrtwdp: equ $0047
rdvrm:  equ $004a
wrtvrm: equ $004d
setwrt: equ $0053
ldirmv: equ $005c
initxt: equ $006c
init32: equ $006f
chput:  equ $00a2
erafnk: equ $00cc
gtstck: equ $00d5
gttrig: equ $00d8
breakx: equ $00b7

linl40: equ $f3ae
linl32: equ $f3af
csry:   equ $f3dc
csrx:   equ $f3dd
forclr: equ $f3e9
bakclr: equ $f3ea
bdrclr: equ $f3eb
rndx:   equ $f857
htimi:  equ $fd9f
rg1sav: equ $f3e0

	;; -------------------------------------------------------------------
	;; print
	;; -------------------------------------------------------------------
	;; hl = pointer to 0 terminated string
	;; -------------------------------------------------------------------

prstr:
	ld   a,[hl]
	inc  hl
	or   a
	ret  z
	call chput
	jr   prstr

	;; -------------------------------------------------------------------
	;; delay
	;; -------------------------------------------------------------------

delay:
	ei
_delay:
	dec a
	halt
	jp  nz,_delay
	ret
	
	;; -------------------------------------------------------------------
	;; bold_font
	;; -------------------------------------------------------------------

bold_font:
	ld   bc,$0400
	ld   h,c
	ld   l,c
_bold_loop:
	call rdvrm
	ld   e,a
	rra
	or   e
	call wrtvrm
	inc  hl
	dec  bc
	ld   a,c
	or   b
	jr   nz,_bold_loop
	ret

	;; -------------------------------------------------------------------
	;; rand8
	;; -------------------------------------------------------------------
	;; out:	a = 8 bits random number
	;; -------------------------------------------------------------------

rand8:
	ld   a,[rndx]
	and  $b8
	scf
	jp   po,_rand8
	ccf
_rand8: ld   a,[rndx]
	rla
	ld   [rndx],a
	ret
